/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef _mcp_requests_h_
#define _mcp_requests_h_

#include "mx_int.h"


#define MX_MCP_ETHER_FLAGS_VALID   0x1
#define MX_MCP_ETHER_FLAGS_LAST    0x2
#define MX_MCP_ETHER_FLAGS_HEAD    0x4
#define MX_MCP_ETHER_FLAGS_CKSUM   0x8
#define MX_MCP_ETHER_FLAGS_GATEWAY 0x10

#define MX_MCP_ETHER_MAX_PSEUDO_OFF 128

#define MX_MCP_SEND_TRUC_MAX_SIZE 51
#define MX_MCP_SEND_CONNECT_MAX_SIZE 47
#define MX_MCP_SEND_TINY_MAX_SIZE 39


typedef enum {
  MX_MCP_KREQ_NONE = 0,
  MX_MCP_KREQ_RAW,
  MX_MCP_KREQ_QUERY,
} mcp_kreq_type_t;

typedef enum {
  MX_MCP_UREQ_NONE = 0,
  MX_MCP_UREQ_SEND_TRUC,
  MX_MCP_UREQ_SEND_CONNECT,
  MX_MCP_UREQ_SEND_TINY,
  MX_MCP_UREQ_SEND_SMALL,
  MX_MCP_UREQ_SEND_MEDIUM,
  MX_MCP_UREQ_SEND_MEDIUM_CONT,
  MX_MCP_UREQ_SEND_RNDV,
  MX_MCP_UREQ_SEND_NOTIFY,
  MX_MCP_UREQ_PULL,
  MX_MCP_UREQ_WAKE,
  MX_MCP_UREQ_PIOBENCH,
} mcp_ureq_type_t;


/* 64 Bytes */
typedef struct
{
  uint8_t pad0;
  uint8_t dest_endpt;
  uint16_t dest_peer_index;
  uint8_t length;
  uint8_t pad1;
  uint16_t lib_cookie;
  uint32_t session;
  uint8_t data[MX_MCP_SEND_TRUC_MAX_SIZE];
  uint8_t type;
} mcp_ureq_truc_t;

/* 64 Bytes */
typedef struct
{
  uint8_t pad0;
  uint8_t dest_endpt;
  uint16_t pad1;
  uint8_t length;
  uint8_t pad2;
  uint16_t lib_seqnum;
  uint16_t lib_cookie;
  uint16_t dest_peer_index;
  uint32_t pad3;
  uint8_t data[MX_MCP_SEND_CONNECT_MAX_SIZE];
  uint8_t type;
} mcp_ureq_connect_t;

/* 64 Bytes */
typedef struct
{
  uint8_t pad0;
  uint8_t dest_endpt;
  uint16_t dest_peer_index;
  uint16_t length;
  uint16_t lib_cookie;
  uint16_t lib_seqnum;
  uint16_t lib_piggyack;
  uint32_t match_a;
  uint32_t match_b;
  uint32_t session;
  uint8_t data[MX_MCP_SEND_TINY_MAX_SIZE];
  uint8_t type;
} mcp_ureq_tiny_t;

/* 64 Bytes */
typedef struct
{
  uint8_t pad0;
  uint8_t dest_endpt;
  uint16_t dest_peer_index;
  uint16_t length;
  uint16_t lib_cookie;
  uint16_t lib_seqnum;
  uint16_t lib_piggyack;
  uint32_t match_a;
  uint32_t match_b;
  uint32_t session;
  uint16_t offset;
  uint8_t pad1[37];
  uint8_t type;
} mcp_ureq_small_t;

/* 64 Bytes */
typedef struct
{
  uint8_t pad0;
  uint8_t dest_endpt;
  uint16_t dest_peer_index;
  uint16_t length;
  uint16_t lib_cookie;
  uint16_t lib_seqnum;
  uint16_t lib_piggyack;
  uint32_t match_a;
  uint32_t match_b;
  uint32_t session;
  uint16_t sendq_index;
  uint8_t credits;
  uint8_t pipeline;
  uint8_t pad1[35];
  uint8_t type;
} mcp_ureq_medium_t;

/* 64 Bytes */
typedef struct
{
  uint8_t pad0;
  uint8_t dest_endpt;
  uint16_t dest_peer_index;
  uint32_t session;
  uint32_t length;
  uint8_t target_rdmawin_id;
  uint8_t target_rdmawin_seqnum;
  uint16_t target_rdma_offset;
  uint8_t origin_rdmawin_id;
  uint8_t origin_rdmawin_seqnum;
  uint16_t origin_rdma_offset;
  uint16_t lib_cookie;
  uint8_t pad1[41];
  uint8_t type;
} mcp_ureq_pull_t;

/* 64 Bytes */
typedef struct
{
  uint8_t pad0;
  uint8_t dest_endpt;
  uint16_t dest_peer_index;
  uint32_t session;
  uint32_t length;
  uint8_t target_rdmawin_id;
  uint8_t target_rdmawin_seqnum;
  uint16_t pad1;
  uint16_t lib_cookie;
  uint16_t lib_seqnum;
  uint16_t lib_piggyack;
  uint8_t pad2[41];
  uint8_t type;
} mcp_ureq_notify_t;

/* 64 Bytes */
typedef struct
{
  uint32_t eventq_flow;
  uint8_t pad[59];
  uint8_t type;
} mcp_ureq_wake_t;

/* 32 Bytes */
typedef struct
{
  uint8_t pad[60];
  uint16_t lib_cookie;
  uint8_t length;
  uint8_t type;
} mcp_ureq_piobench_t;


/* 64 Bytes */
typedef union
{
  mcp_ureq_truc_t truc;
  mcp_ureq_connect_t connect;
  mcp_ureq_tiny_t tiny;
  mcp_ureq_small_t small;
  mcp_ureq_medium_t medium;
  mcp_ureq_notify_t notify;
  mcp_ureq_pull_t pull;
  mcp_ureq_wake_t wake;
  mcp_ureq_piobench_t piobench;
  struct {
    uint8_t pad[63];
    uint8_t type;
  } basic;
  uint64_t int_array[64/8];
} mcp_ureq_t;


/* 24 Bytes */
typedef struct
{
  uint32_t addr_high;
  uint32_t addr_low;
  uint32_t context_low;
  uint32_t context_high;
  uint16_t msg_offset;
  uint16_t msg_length;
  uint16_t route_length;
  uint8_t port;
  uint8_t type;
} mcp_kreq_raw_t;

/* 4 Bytes */
typedef struct
{
  uint16_t peer_index;
  uint8_t query_type;
  uint8_t type;
} mcp_kreq_query_t;

/* 32 Bytes */
typedef union
{
  struct {
    uint8_t pad[32 - sizeof (mcp_kreq_raw_t)];
    mcp_kreq_raw_t req;
  } raw;
  struct {
    uint8_t pad[32 - sizeof (mcp_kreq_query_t)];
    mcp_kreq_query_t req;
  } query;
  struct {
    uint8_t pad[31];
    uint8_t type;
  } basic;
  uint64_t int64_array[32/8];
} mcp_kreq_t;


/* 16 Bytes */
typedef union
{
  struct {
    uint32_t dest_low32;
    uint16_t dest_high16;
    uint16_t cksum_offset;      /* where to start computing cksum */
    uint16_t pseudo_hdr_offset; /* where to store cksum */
    uint16_t peer_index;
    uint8_t  pad[3];
    uint8_t  flags;
  } head;
  struct {
    uint32_t addr_high;
    uint32_t addr_low;
    uint16_t length;
    uint8_t  pad[5];
    uint8_t  flags;
  } frag;
} mcp_kreq_ether_send_t;

/* 8 Bytes */
typedef struct
{
  uint32_t addr_high;
  uint32_t addr_low;
} mcp_kreq_ether_recv_t;

#endif  /* _mcp_requests_h_ */
